# -*- coding: utf-8 -*-
"""
Created on Wed Apr 21 08:38:11 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os
from mpl_toolkits.axes_grid1 import Divider, Size


def adjust_box_widths(g, fac):
    """
    Adjust the widths of a seaborn-generated boxplot.
    """

    # iterating through Axes instances
    for ax in g.axes:

        # iterating through axes artists:
        for c in ax.get_children():

            # searching for mpl.patches.PathPatches
            if isinstance(c, mpl.patches.PathPatch):
                # getting current width of box:
                p = c.get_path()
                verts = p.vertices
                verts_sub = verts[:-1]
                xmin = np.min(verts_sub[:, 0])
                xmax = np.max(verts_sub[:, 0])
                xmid = 0.5*(xmin+xmax)
                xhalf = 0.5*(xmax - xmin)

                # setting new width of box
                xmin_new = xmid-fac*xhalf
                xmax_new = xmid+fac*xhalf
                verts_sub[verts_sub[:, 0] == xmin, 0] = xmin_new
                verts_sub[verts_sub[:, 0] == xmax, 0] = xmax_new

                # setting new width of median line
                for l in ax.lines:
                    if np.all(l.get_xdata() == [xmin, xmax]):
                        l.set_xdata([xmin_new, xmax_new])

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

CM_SUBSECTION_ORANGES = np.linspace(0.3, 1.0, 1000) 
COLOURS_ORANGES = [ cm.Oranges(x) for x in CM_SUBSECTION_ORANGES ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
data_folder_path = main_folder_path
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================

file_name = 'first measurements only.csv'
file_path = os.path.join(data_folder_path,file_name)
df = pd.read_csv(file_path) 
df_nonNeg = df.copy()
df_nonNeg['Current Density at 3.0 V [mA/cm2]'][df['Current Density at 3.0 V [mA/cm2]'] < 0] = np.nan

"""Calculating the means and the ratios"""
ALDs = df_nonNeg['ALD'].unique()
TFBs = df_nonNeg['TFB concentration [mg/ml]'].unique()
TFBs = np.roll(TFBs, 1)
df_means = pd.DataFrame(0, index=TFBs, columns=ALDs, dtype=float)
df_medians = pd.DataFrame(0, index=TFBs, columns=ALDs, dtype=float)

for ALD in ALDs:
    for TFB in TFBs:
        series = df_nonNeg[(df_nonNeg['ALD'] == ALD) & (df_nonNeg['TFB concentration [mg/ml]'] == TFB)]['Current Density at 3.0 V [mA/cm2]']
        df_means.at[TFB, ALD] = series.mean()
        df_medians.at[TFB, ALD] = series.median()
        
df_means = df_means.reset_index()
df_medians = df_medians.reset_index()

df_means.at[0,'index'] = '0'
df_medians.at[0,'index'] = '0' 
df_means.insert(1, 'Thickness [nm]', [0, 1.6, 3.3, 11, 26])
    
"""Some constants for graphical settings"""
lw = 3
lw_box = lw*1.5
lw_markers = lw
ticksize_major = 8
ticksize_minor = 8

"""Box swarm plot general graphic settings"""
palette = [COLOURS_GREENS[650], COLOURS_ORANGES[400]]
palette_w = ['w', 'w'] # for white faces on the stripplot
marker_size = 8
boxprops = {'linewidth': lw_box}
lineprops = {'linewidth': lw_box}
boxplot_kwargs = dict({'boxprops': boxprops, 'medianprops': lineprops,
                       'whiskerprops': lineprops, 'capprops': lineprops,
                       'width': 0.75})

# =============================================================================
# """Plotting linear"""
# fig = plt.figure(0, figsize=(3, 3))
# h = [Size.Fixed(1.0), Size.Scaled(1.), Size.Fixed(.2)]
# v = [Size.Fixed(0.7), Size.Scaled(1.), Size.Fixed(.5)]
# divider = Divider(fig, (0, 0, 1, 1), h, v, aspect=False)
# # The width and height of the rectangle are ignored.
# ax = plt.axes([0.15, 0.15, 0.85, 0.85])
# 
# ax.plot(df_means['index'], df_means['No ALD']/df_means['10 cycles'], color='k')
# 
# """Axis details"""
# ax.yaxis.set_major_locator(mpl.ticker.MultipleLocator(250))
# ax.set_xlabel('TFB conc.')
# ax.set_ylabel(r'$\mathregular{\bar{j}_{No ALD}/\bar{j}_{10 c.}}$')
# 
# 
# """Graphical details"""
# plt.rcParams['font.size'] = 24
# plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
# plt.rcParams['axes.linewidth'] = lw
# plt.rcParams['lines.linewidth'] = lw*1.5
# 
# ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
# ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
# ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
# ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
# =============================================================================

"""Plotting semilog"""
fig = plt.figure(0, figsize=(3, 3))
h = [Size.Fixed(1.0), Size.Scaled(1.), Size.Fixed(.2)]
v = [Size.Fixed(0.7), Size.Scaled(1.), Size.Fixed(.5)]
divider = Divider(fig, (0, 0, 1, 1), h, v, aspect=False)
# The width and height of the rectangle are ignored.
ax = plt.axes([0.15, 0.15, 0.85, 0.85])

ax.semilogy(df_means['Thickness [nm]'], df_means['No ALD']/df_means['10 cycles'], color='k')

"""Axis details"""
#plt.xticks((0,1,2,3,4), ('0', '1.6', '3.3', '11', '26'))
ax.xaxis.set_major_locator(mpl.ticker.MultipleLocator(10))
ax.xaxis.set_minor_locator(mpl.ticker.MultipleLocator(5))
ax.yaxis.set_major_locator(mpl.ticker.LogLocator(base=10, numticks=8))
ax.set_xlabel('Thickness [nm]')
ax.set_ylabel(r'$\mathregular{\bar{J}_{Free}/\bar{J}_{Al_2O_3}}$')

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=24)    # fontsize of the x and y labels - reduced relative to other figures because inset
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw*1.5

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

"""Annotation"""
ax.text(0.1, 0.1, '3 V',
        horizontalalignment='left',
        verticalalignment='bottom',
        transform=ax.transAxes)


"""Exporting plots"""
plot_name = 'Plot Electron-only Ratio of Means inset'
export_name_pdf = plot_name + '.pdf'
export_name_svg = plot_name + '.svg'
#export_name_eps = plot_name + '.eps'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
#eps_path = os.path.join(export_folder_path,export_name_eps)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path, bbox_inches='tight')
fig.savefig(svg_path, bbox_inches='tight')
#fig.savefig(eps_path, bbox_inches='tight')
plt.close(fig)


